<?php
// 環境に合わせて以下の値を変更してください
$secret_key = 'YOUR_SECURE_ACCESS_KEY'; // PowerShellスクリプトと一致させる秘密鍵
$backup_dir = '/path/to/your/wordpress/wp-content/uploads/backwpup-xxxxxxxx-backups/'; // BackWPupのバックアップディレクトリへのフルパス
$log_file = '/path/to/your/log/backwpup_download.log'; // ログファイルのパス

// POSTリクエストの検証
if (!isset($_POST['access_key']) || $_POST['access_key'] !== $secret_key || !isset($_POST['command'])) {
    http_response_code(403);
    echo "Error: Access Denied or Invalid Request.";
    exit;
}

$command = $_POST['command'];

// ログ関数
function write_log($message) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($log_file, "[$timestamp] $message\n", FILE_APPEND);
}

// BackWPupのzipファイルのみをフィルタリング
function get_zip_files() {
    global $backup_dir;
    if (!is_dir($backup_dir)) {
        write_log("Error: Backup directory does not exist: $backup_dir");
        return [];
    }
    
    // ディレクトリ内のすべてのファイルを取得
    $files = @scandir($backup_dir);
    if ($files === false) {
        write_log("Error: Could not scan backup directory: $backup_dir");
        return [];
    }

    $zip_files = [];
    foreach ($files as $file) {
        // .zipで終わり、かつ、ファイルであること、ディレクトリではないことを確認
        if (preg_match('/\.zip$/i', $file) && is_file($backup_dir . $file)) {
            $zip_files[] = $file;
        }
    }
    return $zip_files;
}

switch ($command) {
    case 'list':
        // 1. list コマンド: zipファイルの一覧を返す
        $zip_files = get_zip_files();
        header('Content-Type: application/json');
        echo json_encode(['status' => 'success', 'files' => $zip_files]);
        write_log("LIST command executed. Found " . count($zip_files) . " files.");
        break;

    case 'get':
        // 2. get コマンド: 指定されたファイルをダウンロードさせる
        if (!isset($_POST['filename']) || empty($_POST['filename'])) {
            http_response_code(400);
            echo "Error: 'filename' parameter is required for 'get' command.";
            write_log("GET command failed: 'filename' parameter missing.");
            exit;
        }

        $filename = basename($_POST['filename']); // basenameでディレクトリトラバーサル攻撃を防止
        $filepath = $backup_dir . $filename;

        // ファイルの存在と安全性の確認
        if (!in_array($filename, get_zip_files())) {
            http_response_code(404);
            echo "Error: File not found or is not a valid backup file: $filename";
            write_log("GET command failed: File not found or invalid: $filename");
            exit;
        }

        // ファイルのダウンロード処理
        if (is_readable($filepath)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="' . $filename . '"');
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($filepath));
            ob_clean();
            flush();
            readfile($filepath);
            write_log("GET command executed. File downloaded: $filename");
            exit;
        } else {
            http_response_code(500);
            echo "Error: Could not read file: $filename";
            write_log("GET command failed: Could not read file: $filename");
            exit;
        }

    default:
        http_response_code(400);
        echo "Error: Invalid command.";
        write_log("Invalid command received: $command");
        break;
}

?>