﻿namespace Asynchronization;

// GUIライクなイベントループ。
// スレッドIDが固定され、非同期処理が並行処理で実行されます。
internal class GuiLikeEventLoop : SynchronizationContext
{
    private readonly object _lock = new();
    private readonly Queue<(SendOrPostCallback, object?)> _queue = new();

    public static void Run(Func<Task> asyncFunc)
    {
        var context = new GuiLikeEventLoop();
        SetSynchronizationContext(context);
        try
        {
            var isTerminating = false;
            asyncFunc().ContinueWith(task =>
            {
                lock (context._lock)
                {
                    isTerminating = true;
                    Monitor.Pulse(context._lock);
                }
            });
            lock (context._lock)
            {
                while (!isTerminating)
                {
                    if (context._queue.TryDequeue(out var item))
                    {
                        Monitor.Exit(context._lock);
                        try { item.Item1.Invoke(item.Item2); }
                        finally { Monitor.Enter(context._lock); }
                    }
                    else
                        Monitor.Wait(context._lock);
                }
            }
        }
        finally
        {
            SetSynchronizationContext(null);
        }
    }

    public override void Post(SendOrPostCallback d, object? state)
    {
        lock (_lock)
        {
            _queue.Enqueue((d, state));
            Monitor.Pulse(_lock);
        }
    }
}
