﻿namespace Parallelization;

internal abstract class Prime
{
    // 素数をカウント
    public abstract (int, int) Count(int searchLength);

    // 範囲内の素数をカウント
    protected static int CountRange(int begin, int end)
    {
        var count = 0;
        for (var num = begin; num < end; num++)
            if (IsPrime(num)) count++;
        return count;
    }

    // 素数かどうか
    private static bool IsPrime(int n)
    {
        if (n <= 1) return false;
        if (n <= 3) return true;
        if (n % 2 == 0 || n % 3 == 0) return false;
        for (var i = 5; i * i <= n; i += 6)
            if (n % i == 0 || n % (i + 2) == 0)
                return false;
        return true;
    }

    // 範囲分割
    protected record struct Range(int Begin, int End);

    protected static Range[] SplitRange(int begin, int end, int count)
    {
        // begin はその値を含む、end はその値を含まない。
        // begin = 0, end = 100, count = 3 の場合、戻り値は (0, 33), (33, 66), (66, 100)。
        var ranges = new Range[count];
        var step = (end - begin) / count;
        for (var index = 0; index < count; index++)
            ranges[index] = new Range(begin + index * step, index == count - 1 ? end : begin + (index + 1) * step);
        return ranges;
    }
}
