﻿using System.Diagnostics;

namespace Parallelization;

internal static class Program
{
    public static int Main(string[] args)
    {
        // 引数が2個あるとき、子プロセスの処理を実行
        if (args.Length == 2)
            return UsingProcess.ChildProcessMain(args);

        // 探索範囲をセット。引数が1個のときはその値、引数なしのときは1億。
        var searchLength = args.Length == 1 ? int.Parse(args[0]) : 100_000_000;
        Console.WriteLine($"探索範囲: 1-{searchLength:N0}");

        // 処理時間計測と結果出力
        var primes = new Prime[] {
            new SingleThread(),
            new UsingProcess(),
            new UsingThread(),
            new UsingThreadPool(),
            new UsingTask(),
            new UsingParallelFor(),
            new UsingParallelForEach(),
            new UsingPartitioner()
        };
        double? standardTime = null;
        foreach (var prime in primes)
        {
            Console.WriteLine();
            Console.WriteLine($"クラス名: {prime.GetType().Name}");
            var stopwatch = Stopwatch.StartNew();
            var result = prime.Count(searchLength);
            stopwatch.Stop();
            standardTime ??= stopwatch.Elapsed.TotalSeconds;
            Console.WriteLine($"分割数  : {result.Item1}");
            Console.WriteLine($"素数の数: {result.Item2:N0}");
            Console.WriteLine($"実行時間: {stopwatch.Elapsed.TotalSeconds:N3} 秒");
            Console.WriteLine($"速度比  : {standardTime / stopwatch.Elapsed.TotalSeconds:N2}");
        }

        return 0;
    }
}
