﻿using System.Collections.Concurrent;

namespace Parallelization;

internal class UsingParallelFor : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount * 3 + 1);

        // 並列実行
        var results = new ConcurrentBag<int>();
        Parallel.For(0, ranges.Length, index =>
        {
            var range = ranges[index];
            var result = CountRange(range.Begin, range.End);
            results.Add(result);
        });

        // 合計を返す
        return (ranges.Length, results.Sum());
    }
}
