﻿using System.Collections.Concurrent;

namespace Parallelization;

internal class UsingParallelForEach : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount * 3 + 1);

        // 並列実行
        var results = new ConcurrentBag<int>();
        Parallel.ForEach(ranges, range =>
        {
            var result = CountRange(range.Begin, range.End);
            results.Add(result);
        });

        // 合計を返す
        return (ranges.Length, results.Sum());
    }
}
