﻿using System.Collections.Concurrent;

namespace Parallelization;

internal class UsingPartitioner : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var partitioner = Partitioner.Create(1, searchLength + 1);

        // 並列実行
        var results = new ConcurrentBag<int>();
        Parallel.ForEach(partitioner, range =>
        {
            var result = CountRange(range.Item1, range.Item2);
            results.Add(result);
        });

        // 合計を返す
        return (results.Count, results.Sum());
    }
}
