﻿using System.Diagnostics;

namespace Parallelization;

internal class UsingProcess : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount);

        // 子プロセスを開始
        var processes = new List<Process>();
        foreach (var range in ranges)
        {
            var process = Process.Start(Environment.ProcessPath!, $"{range.Begin} {range.End}");
            processes.Add(process!);
        }

        // 子プロセスが終了するのを待機し、結果を加算
        var sum = 0;
        foreach (var process in processes)
        {
            process.WaitForExit();
            sum += process.ExitCode;
        }

        // 合計を返す
        return (ranges.Length, sum);
    }

    // 子プロセスのMain
    public static int ChildProcessMain(string[] args)
    {
        return CountRange(int.Parse(args[0]), int.Parse(args[1]));
    }
}
