﻿namespace Parallelization;

internal class UsingTask : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount * 3 + 1);

        // タスクを開始
        var tasks = new List<Task<int>>();
        foreach (var range in ranges)
        {
            var task = new Task<int>(() => CountRange(range.Begin, range.End));
            task.Start();
            tasks.Add(task);
        }

        // タスクが完了するのを待機し、結果を加算
        var sum = 0;
        foreach (var task in tasks)
        {
            task.Wait();
            sum += task.Result;
        }

        // 合計を返す
        return (ranges.Length, sum);
    }
}
