﻿namespace Parallelization;

internal class UsingThread : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount);

        // スレッドを開始
        var states = new List<State>();
        foreach (var range in ranges)
        {
            var state = new State(range.Begin, range.End);
            state.Thread = new Thread(state.Main);
            state.Thread.Start();
            states.Add(state);
        }

        // スレッドが終了するのを待機し、結果を加算
        var sum = 0;
        foreach (var state in states)
        {
            state.Thread!.Join();
            sum += state.Result;
        }

        // 合計を返す
        return (ranges.Length, sum);
    }

    private class State(int begin, int end)
    {
        public readonly int Begin = begin;
        public readonly int End = end;
        public Thread? Thread;
        public int Result;

        public void Main()
        {
            Result = CountRange(Begin, End);
        }
    }
}
