﻿namespace Parallelization;

internal class UsingThreadPool : Prime
{
    public override (int, int) Count(int searchLength)
    {
        // タスクを分割
        var ranges = SplitRange(1, searchLength + 1, Environment.ProcessorCount * 3 + 1);

        // タスクを開始
        var states = new List<State>();
        foreach (var range in ranges)
        {
            var state = new State(range.Begin, range.End);
            ThreadPool.QueueUserWorkItem(SetResult, state);
            states.Add(state);
        }

        // タスクが完了するのを待機し、結果を加算
        var sum = 0;
        foreach (var state in states)
        {
            state.Completion.Wait();
            sum += state.Result;
        }

        // 合計を返す
        return (ranges.Length, sum);
    }

    private class State(int begin, int end)
    {
        public readonly int Begin = begin;
        public readonly int End = end;
        public readonly ManualResetEventSlim Completion = new();
        public int Result;
    }

    private static void SetResult(object? state)
    {
        var s = (State)state!;
        s.Result = CountRange(s.Begin, s.End);
        s.Completion.Set();
    }
}
