﻿// DBモックサーバー
using System.Net;
using System.Net.Sockets;

using var listener = new TcpListener(IPAddress.Any, 9000);
listener.Start();
Console.WriteLine("DB Mock Server started on port 9000.");
for (var index = 0; ; index++)
{
    var client = listener.AcceptTcpClient();
    var id = index;
    _ = Task.Run(async () =>
    {
        try
        {
            using var client2 = client;
            using var stream = client2.GetStream();
            using var reader = new StreamReader(stream);
            using var writer = new StreamWriter(stream) { AutoFlush = true };
            while (true)
            {
                var command = await reader.ReadLineAsync();
                await Task.Delay(10);
                await writer.WriteLineAsync("100");
                //Console.WriteLine($"{id}: Database request finished.");
            }
        }
        catch { }
    });
}
