﻿// Webクライアント
using System.Diagnostics;

using var client = new HttpClient();
var requestCount = 0;

// 統計情報を3秒毎に出力
var statTask = Task.Run(async () =>
{
    while (true)
    {
        var stopwatch = Stopwatch.StartNew();
        await Task.Delay(3000);
        var thread = await client.GetStringAsync($"http://localhost:5000/thread");
        var request = Interlocked.Exchange(ref requestCount, 0);
        Console.WriteLine($"{thread} threads, {request / stopwatch.Elapsed.TotalSeconds:0} req/sec");
    }
});

Console.WriteLine("Web Client started.");
await Task.Delay(10_000);
await Test("sync", 10, 30_000);
await Test("sync", 100, 70_000);
await Test("async", 100, 30_000);

async Task Test(string type, int worker, int delay)
{
    Console.WriteLine($"\n--- {type} method, {worker} workers ---\nWeb access started.");
    var url = $"http://localhost:5000/{type}";
    using var cancellation = new CancellationTokenSource(delay);
    await Task.WhenAll(Enumerable.Range(0, worker).Select(_ => Task.Run(async () =>
    {
        while (!cancellation.IsCancellationRequested)
        {
            await client.GetStringAsync(url);
            Interlocked.Increment(ref requestCount);
        }
    })));
    Console.WriteLine($"Web access stopped.");
    await Task.Delay(27_000);
}
