﻿// Webサーバー
using Microsoft.AspNetCore.Builder; // パッケージ：ServiceStack.Kestrel
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Logging;
using System.Collections.Concurrent;
using System.Net;
using System.Net.Sockets;

var builder = WebApplication.CreateBuilder(args);
builder.WebHost.UseKestrel().UseUrls("http://localhost:5000");
builder.Logging.SetMinimumLevel(LogLevel.None);
var app = builder.Build();

// 同期処理
app.MapGet("/sync", async () =>
{
    using var connection = DbConnection.Open();
    connection.Writer.WriteLine("SELECT COUNT(*) FROM Table1");
    var result = connection.Reader.ReadLine();
    return $"Result: {result}";
});

// 非同期処理
app.MapGet("/async", async () =>
{
    using var connection = DbConnection.Open();
    await connection.Writer.WriteLineAsync("SELECT COUNT(*) FROM Table1");
    var result = await connection.Reader.ReadLineAsync();
    return $"Result: {result}";
});

// スレッド数を取得
app.MapGet("/thread", async () =>
{
    return ThreadPool.ThreadCount.ToString();
});

Console.WriteLine("Web Server started on port 5000.");
ThreadPool.GetMinThreads(out var minWorkers, out _);
Console.WriteLine($"Minimum worker threads: {minWorkers}");
await app.RunAsync();

// DBモックサーバーへの接続
class DbConnection : IDisposable
{
    private static readonly ConcurrentQueue<DbConnection> _pool = new();
    private readonly TcpClient _client = new();
    public readonly StreamWriter Writer;
    public readonly StreamReader Reader;

    public static DbConnection Open()
    {
        if (!_pool.TryDequeue(out var connection))
            connection = new DbConnection();
        return connection;
    }

    public DbConnection()
    {
        _client.Connect(IPAddress.Loopback, 9000);
        var stream = _client.GetStream();
        Writer = new StreamWriter(stream) { AutoFlush = true };
        Reader = new StreamReader(stream);
    }

    public void Dispose()
    {
        _pool.Enqueue(this);
    }
}
